/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "udm_common.h"
#include "udm_socket.h"
#include "udm_host.h"
#include "udm_utils.h"
#include "udm_xmalloc.h"
#include "udm_http.h"
#include "udm_conf.h"
#include "udm_log.h"
#include "udm_contentencoding.h"
#include "udm_mimetype.h"
#include "udm_url.h"
#include "udm_vars.h"
#include "udm_hrefs.h"

int UdmHTTPConnect(UDM_ENV * Conf,UDM_CONN *connp, char *hostname, int port, int timeout){
	size_t len;
    
        if (!connp)
                return -1;

        if (!hostname)
    		return -1;

	if (!port)
		return -1;
	connp->port = port;
	connp->timeout = timeout;

        len = strlen(hostname);
        connp->hostname = UdmXrealloc(connp->hostname, len+1);
        snprintf(connp->hostname, len+1, "%s", hostname);

        if (UdmHostLookup(&Conf->Hosts,connp)) /* FIXME: not reentrant */
                return -1;

        if (socket_open(connp))
                return -1;

        if (socket_connect(connp))
                return -1;
					        				
	return 0;
}


void UdmParseHTTPResponse(UDM_AGENT * Indexer,UDM_DOCUMENT * Doc){			
	char	*token, *lt;
	char	*headers;
	int     oldstatus;
	
	Doc->Buf.content=NULL;
	oldstatus = UdmVarListFindInt(&Doc->Sections, "Status", 0);
	
	/* Cut HTTP response header first        */
	for(token=Doc->Buf.buf;*token;token++){
		if(!strncmp(token,"\r\n\r\n",4)){
			*token='\0';
			Doc->Buf.content=token+4;
			break;
		}else
		if(!strncmp(token,"\n\n",2)){
			*token='\0';
			Doc->Buf.content=token+2;
			break;
		}
	}
	
	/* Bad response, return */
	if(!Doc->Buf.content)return;
	
	/* Copy headers not to break them */
	headers = strdup(Doc->Buf.buf);
	
	/* Now lets parse response header lines */
	token=strtok_r(headers,"\r\n",&lt);
	
	if(!token)return;
	
	if(!strncmp(token,"HTTP/",5)){
	        int status = atoi(token + 8);
		UdmVarListReplaceInt(&Doc->Sections, "Status", (oldstatus > status) ? oldstatus : status );
		UdmLog(Indexer,UDM_LOG_DEBUG,"%s",token);
	}else{
		return;
	}
	token=strtok_r(NULL,"\r\n",&lt);
	
	while(token){
		char *val;
		
		UdmLog(Indexer,UDM_LOG_DEBUG,"%s",token);
		
		val=strchr(token,':');
		if(!val){
			UdmLog(Indexer,UDM_LOG_DEBUG,"Incorrect header");
			token=strtok_r(NULL,"\r\n",&lt);
			continue;
		}
		*val++='\0';
		val=UdmTrim(val," \t:");
		
		UdmVarListReplaceStr(&Doc->Sections,token,val);
		
		token=strtok_r(NULL,"\r\n",&lt);
	}
	free(headers);
	
	if(!(UdmVarListFind(&Doc->Sections,"Content-Length")))
		UdmVarListAddInt(&Doc->Sections,"Content-Length",Doc->Buf.buf-Doc->Buf.content+(int)Doc->Buf.size);
}
